<?php
$ROOT = getenv('DOCUMENT_ROOT') ;
$DRUPAL_FILE = $ROOT . '/templater/drupal_template.inc' ;
define('TEMPLATE_TITLE', "The DINAMelt Server - results for unnamed job 260101_035502");
require("$DRUPAL_FILE");
echo GetTemplateFile('header_dinamelt.html');
?>

   <h2 class="title">Job Parameters</h2>
   <p>Submitted at Thu 01 Jan 2026 03:55:05 AM UTC</p>
   <p><code>5'-UAUGCUUUCAUAUCCAUUCCA-3'</code> vs. <code>5'-TGGAATGGATATGAAAGCATACC-3'</code><br />
   From 0&deg;C by 1&deg;C to 100&deg;C as RNA<br />
   [A<sub>0</sub>] = 0.00001 M, [B<sub>0</sub>] = 0.00001 M<br />
   [Na<sup>+</sup>] = 1 M, [Mg<sup>++</sup>] = 0 M (oligo mode)
   </p>
   <p>Computation took 1.0 seconds (<a href="log.txt">Log file</a>)</p>

   <h2>Plots</h2>
   <table>
    <tr><th colspan="2"><a href="https://www.unafold.org/help-output.php#conc">Concentration Plot</a></th></tr>
    <tr><td colspan="2"><a href="javascript:void(window.open('conc-big.png', '', 'width=740,height=524'))"><img src="conc.png" width="320" height="224" alt="Concentration plot" /></a></td></tr>
    <tr><td colspan="2">Download: <a href="A-B.conc.ps" title="Concentration plot (Postscript)">Postscript</a> <a href="A-B.conc.pdf" title="Concentration plot (PDF)">PDF</a> <a href="A-B.conc" title="Concentration plot (text)">Text</a></td></tr>
    <tr>
     <th><a href="https://www.unafold.org/help-output.php#Cp">Heat Capacity Plot</a></th>

     <th><a href="https://www.unafold.org/help-output.php#ext">Absorbance Plot</a></th>

    </tr>
    <tr>
     <td><a href="javascript:void(window.open('Cp-big.png', '', 'width=740,height=524'))"><img src="Cp.png" width="320" height="224" alt="Heat capacity plot" /></a></td>

     <td><a href="javascript:void(window.open('ext-big.png', '', 'width=740,height=524'))"><img src="ext.png" width="320" height="224" alt="Extinction plot" /></a></td>

    </tr>
    <tr align="center">
     <td>Download: <a href="A-B.Cp.ps" title="Heat capacity plot (Postscript)">Postscript</a> <a href="A-B.Cp.pdf" title="Heat capacity plot (PDF)">PDF</a> <a href="A-B.ens.Cp" title="Heat capacity plot (text)">Text</a></td>

     <td>Download: <a href="A-B.ext.ps" title="Absorbance plot (Postscript)">Postscript</a> <a href="A-B.ext.pdf" title="Absorbance plot (PDF)">PDF</a> <a href="A-B.ens.ext" title="Asorbance plot (text)">Text</a></td>

    </tr>
    <tr align="center">
     <td>Download detailed plot: <a href="A-B.Cp2.ps" title="Detailed heat capacity plot (Postscript)">Postscript</a> <a href="A-B.Cp2.pdf" title="Detailed heat capacity plot (PDF)">PDF</a></td>

     <td>Download detailed plot: <a href="A-B.ext2.ps" title="Detailed absorbance plot (Postscript)">Postscript</a> <a href="A-B.ext2.pdf" title="Detailed absorbance plot (PDF)">PDF</a></td>

    </tr>
   </table>

   <h2>Probability Dot Plots</h2>
   <form action="https://www.unafold.org/cgi-bin/DINAMelt/hybrid2-plot.cgi" target="pic" method="get" onsubmit="window.open('', 'pic', 'width=632,height=632')"><p>
    <input type="hidden" name="tag" value="260101/035502" />
    <input type="submit" value="View" /> <label for="species">plot of</label>
    <select id="species" name="species">

     <option value="A">A</option>

     <option value="B">B</option>

     <option value="A-A">A-A</option>

     <option value="B-B">B-B</option>

     <option value="A-B">A-B</option>

    </select> <label for="temperature">at</label>
    <select id="temperature" name="temperature">

     <option value="0">0</option>

     <option value="1">1</option>

     <option value="2">2</option>

     <option value="3">3</option>

     <option value="4">4</option>

     <option value="5">5</option>

     <option value="6">6</option>

     <option value="7">7</option>

     <option value="8">8</option>

     <option value="9">9</option>

     <option value="10">10</option>

     <option value="11">11</option>

     <option value="12">12</option>

     <option value="13">13</option>

     <option value="14">14</option>

     <option value="15">15</option>

     <option value="16">16</option>

     <option value="17">17</option>

     <option value="18">18</option>

     <option value="19">19</option>

     <option value="20">20</option>

     <option value="21">21</option>

     <option value="22">22</option>

     <option value="23">23</option>

     <option value="24">24</option>

     <option value="25">25</option>

     <option value="26">26</option>

     <option value="27">27</option>

     <option value="28">28</option>

     <option value="29">29</option>

     <option value="30">30</option>

     <option value="31">31</option>

     <option value="32">32</option>

     <option value="33">33</option>

     <option value="34">34</option>

     <option value="35">35</option>

     <option value="36">36</option>

     <option value="37">37</option>

     <option value="38">38</option>

     <option value="39">39</option>

     <option value="40">40</option>

     <option value="41">41</option>

     <option value="42">42</option>

     <option value="43">43</option>

     <option value="44">44</option>

     <option value="45">45</option>

     <option value="46">46</option>

     <option value="47">47</option>

     <option value="48">48</option>

     <option value="49">49</option>

     <option value="50">50</option>

     <option value="51">51</option>

     <option value="52">52</option>

     <option value="53">53</option>

     <option value="54">54</option>

     <option value="55">55</option>

     <option value="56">56</option>

     <option value="57">57</option>

     <option value="58">58</option>

     <option value="59">59</option>

     <option value="60">60</option>

     <option value="61">61</option>

     <option value="62">62</option>

     <option value="63">63</option>

     <option value="64">64</option>

     <option value="65">65</option>

     <option value="66">66</option>

     <option value="67">67</option>

     <option value="68">68</option>

     <option value="69">69</option>

     <option value="70">70</option>

     <option value="71">71</option>

     <option value="72">72</option>

     <option value="73">73</option>

     <option value="74">74</option>

     <option value="75">75</option>

     <option value="76">76</option>

     <option value="77">77</option>

     <option value="78">78</option>

     <option value="79">79</option>

     <option value="80">80</option>

     <option value="81">81</option>

     <option value="82">82</option>

     <option value="83">83</option>

     <option value="84">84</option>

     <option value="85">85</option>

     <option value="86">86</option>

     <option value="87">87</option>

     <option value="88">88</option>

     <option value="89">89</option>

     <option value="90">90</option>

     <option value="91">91</option>

     <option value="92">92</option>

     <option value="93">93</option>

     <option value="94">94</option>

     <option value="95">95</option>

     <option value="96">96</option>

     <option value="97">97</option>

     <option value="98">98</option>

     <option value="99">99</option>

     <option value="100">100</option>

    </select> &deg;C
   </p></form>

   <h2>Van't Hoff Plots</h2>
   <form action="https://www.unafold.org/cgi-bin/DINAMelt/hybrid2-vHp.cgi" method="post"><p>
    <input type="hidden" name="tag" value="260101/035502" />
    <input type="hidden" name="NA" value="RNA" />
    <input type="hidden" name="Ct" value="2e-05" />
    <input type="hidden" name="exclude" value="" />
    <input type="hidden" name="fraction" value="0.1" />
    <input type="hidden" name="Tmelt" value="50" />
    View a van't Hoff plot as... <input type="submit" name="format" value="PNG" /> <input type="submit" name="format" value="Postscript" /> <input type="submit" name="format" value="PDF" /> <input type="submit" name="format" value="Text" /><br />
    The fist time you request a plot there will be a short delay while the van't Hoff data is calculated.
   </p></form>



   <h2>Isothermal Titration Calorimetry Plots</h2>
   <form action="https://www.unafold.org/cgi-bin/DINAMelt/hybrid2-ITC.cgi" method="post"><p>
    <input type="hidden" name="tag" value="260101/035502" />
    <input type="hidden" name="NA" value="RNA" />
    <input type="hidden" name="A0" value="0.00001" />
    <input type="hidden" name="B0" value="0.00001" />
    <input type="hidden" name="exclude" value="" />
    <input type="hidden" name="fraction" value="0.1" />
    <input type="hidden" name="Tmelt" value="50" />
    <label for="vary">Vary concentration of</label> <select id="vary" name="vary"><option value="A">A</option><option value="B">B</option></select><br />
    <label for="temp">Enter one or more temperatures, separated by commas</label>: <input type="text" id="temp" name="temp" value="" size="10"/><br />
    View ITC plot as... <input type="submit" name="format" value="PNG" /> <input type="submit" name="format" value="Postscript" /> <input type="submit" name="format" value="PDF" /> <input type="submit" name="format" value="Text" /><br />
    There will be a short delay while the ITC data is calculated.
   </p></form>

   <h2>Important Numbers</h2>
   <p>
    <a href="https://www.unafold.org/help-output.php#TmConc">T<sub>m</sub>(Conc)</a>: 83.1&deg;C<br />
    <a href="https://www.unafold.org/help-output.php#dG">&#916;G</a>: 50.0 kcal/mol &nbsp; <a href="https://www.unafold.org/help-output.php#dH">&#916;H</a>: 214.1 kcal/mol &nbsp; <a href="https://www.unafold.org/help-output.php#dH">&#916;S</a>: 602.8 cal/mol/K &nbsp; <a href="https://www.unafold.org/help-output.php#TmCp">T<sub>m</sub>(C<sub>p</sub>)</a>: 84.4&deg;C
<br />
    <a href="https://www.unafold.org/help-output.php#TmExt1">T<sub>m</sub>(Ext1)</a>: 83.0&deg;C
    &nbsp;
    <a href="https://www.unafold.org/help-output.php#TmExt2">T<sub>m</sub>(Ext2)</a>: 82.6&deg;C

   </p>
   <p>Download the entire job with all files, formatted as:
    <a href="https://www.unafold.org/cgi-bin/DINAMelt/hybrid2-archive.cgi?tag=260101/035502&amp;format=bz2">tar/bzip2</a>
    <a href="https://www.unafold.org/cgi-bin/DINAMelt/hybrid2-archive.cgi?tag=260101/035502&amp;format=gz">tar/gzip</a>
    <a href="https://www.unafold.org/cgi-bin/DINAMelt/hybrid2-archive.cgi?tag=260101/035502&amp;format=zip">zip</a>
    <br />The first time you ask for an archive there may be a slight delay while it is created.
   </p>

<?php echo GetTemplateFile('footer.html'); ?>
