set terminal postscript enhanced color
set style data lines
set key left
set xlabel 'T ({/Symbol \260}C)'
set xrange [0:100]
set yrange [0:]
set title 'TGGAATGGATATGAAAGCATACC versus UAUGCUUUCAUAUCCAUUCCA'
set output 'A-B.Cp.ps'
set ylabel 'C_p (kcal / mol / K)'
set label 'T_mC_p: 84.4' at 84.3509,22.0947 center
plot 'A-B.ens.Cp' notitle lw 2, 'A-B.ens.TmCp' notitle w i lt 0 lw 2
set nolabel 1
set yrange [*:*]
set output 'A-B.Cp2.ps'
plot 'A-B.A.Cp' t 'A' lw 2, 'A-B.B.Cp' t 'B' lw 2, 'A-B.AA.Cp' t 'AA' lw 2, 'A-B.BB.Cp' t 'BB' lw 2, 'A-B.AB.Cp' t 'AB' lw 2, 'A-B.ens.Cp' t 'Ensemble' lw 2
set output 'A-B.ext.ps'
set ylabel 'Absorbance (M^{-1} cm^{-1} {/Symbol \264} 10^{-6})'
set label 'T_mExt: 82.6' at 82.6104,126686 right
set yrange [0:229920]
plot 'A-B.ens.ext' notitle lw 2, 'A-B.ens.TmExt2' notitle w i lt 0 lw 2
set nolabel 1
set output 'A-B.ext2.ps'
plot 'A-B.A.ext' t 'A' lw 2, 'A-B.B.ext' t 'B' lw 2, 'A-B.AA.ext' t 'AA' lw 2, 'A-B.BB.ext' t 'BB' lw 2, 'A-B.AB.ext' t 'AB' lw 2, 'A-B.ens.ext' t 'Ensemble' lw 2
set yrange [0:1]
set output 'A-B.conc.ps'
set ylabel 'M Fraction'
set arrow from 83.0678, graph 0 to 83.0678, graph 1 nohead lt 0 lw 2
set label 'T_mConc: 83.1' at 83.0678,0.95 left
plot 'A-B.Au' t 'Au' lw 2, 'A-B.Bu' t 'Bu' lw 2, 'A-B.Af' t 'Af' lw 2, 'A-B.Bf' t 'Bf' lw 2, 'A-B.AA' t 'AA' lw 2, 'A-B.BB' t 'BB' lw 2, 'A-B.AB' t 'AB' lw 2
set noarrow 1
set nolabel 1
